using System;
using System.Text;
using System.Collections;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using NppScripts;

//SoldierEPilot 12-10-2014
//For non-commercial use only
public class Script : NppScript
{

 static public string GetSelectedText()
        {
            int start = (int)Win32.SendMessage(Npp.CurrentScintilla, SciMsg.SCI_GETSELECTIONSTART, 0, 0);
            int end = (int)Win32.SendMessage(Npp.CurrentScintilla, SciMsg.SCI_GETSELECTIONEND, 0, 0);
            var text = new StringBuilder(end - start + 1);
            Win32.SendMessage(Npp.CurrentScintilla, SciMsg.SCI_GETSELTEXT, 0, text);
            return text.ToString();
        }

 // Remove all comments
 private static string NoComments(string s)
 {
	  Regex rex=new Regex(@"\/{2,}[\w \t]+");		  
	  string s2=rex.Replace(s,"");
	  rex=new Regex(@"\/\*(.|\n)+?\*\/");
	  s2=rex.Replace(s2,"");
	  rex=new Regex(@"comment\s*?[\{](.|\n)+?\}\;",RegexOptions.IgnoreCase);
	  s2=rex.Replace(s2,"");
	  return(s2);
 }
 
 // Remove empty lines
   private static string NoEmptyLines(string txt)
{   
    Regex rex=new Regex("\r\n\r\n");
    return(rex.Replace(txt,""));
    
 }
 
  private static string NoMultipleSpaces(string listing)
  {
	   Regex rex=new Regex(@"\s{2,}");
	   string s=(rex.Replace(listing,"QQ"));
	   rex=new Regex(@"QQ");
	   s=(rex.Replace(s," "));
	   return(s);
  }
 
 private static string MakeLessSpaces(string listing)
  {
	   Regex rex=new Regex(@"((?<!\w)\s)|(\s(?=\W))");
	   string s=(rex.Replace(listing,"QQ"));
	   rex=new Regex( @"QQ");
	   s=(rex.Replace(s,""));
	   return(s);
  }
  
  private static string OneLine(string listing)
  {
	   Regex rex=new Regex(@"[\r]|[\n]");
	   string s=(rex.Replace(listing,""));
	   return(s);
  }
  
  //Function listing-to *.csv line
 private static string RPLS(string tx)
 {
	   string fName;
	   Regex rex,rex2,rex3,rex4,rex5,rex6;
	   //remove all crap
	   tx=NoMultipleSpaces(NoEmptyLines(tx));
	   tx=OneLine(MakeLessSpaces(tx));
	   // Split function into the name and body
	   // make string ID from this name
	   rex=new Regex(@"^.+?\=");
	   Match MT=rex.Match(tx);
	   fName=MT.Value;
	   rex.Replace(tx,"QQ");
	   rex2=new Regex("QQ");
	   rex2.Replace(tx,"");
	   fName=fName.Replace(" ","");
	   fName=fName.Replace("=","");
	   fName="f_"+fName.ToLower();
	   fName=@"""" + fName + @"""";
	   rex4=new Regex(@"^.+?\{");
	   tx=rex4.Replace(tx,"");
	   rex5=new Regex(@"\}.+?$",RegexOptions.RightToLeft);
	   tx=rex5.Replace(tx,"");
	   rex6=new Regex(@"\n");
	   tx=rex6.Replace(tx,"");
	   // double quotes 
	   rex3=new Regex(@"""");
	   tx=rex3.Replace(tx,@"""""");
	   tx=@"""" + tx + @"""";
	   tx=fName + ", " + tx;
	   return (tx);
 }

 //Add new *.csv line to clipboard
 [STAThread]
    public override void Run()
    {
	    string txt;
	    txt=GetSelectedText();
		if ((txt.Length)>0)
		{
			txt=RPLS(txt);
			Clipboard.SetText(txt, TextDataFormat.Text);
			MessageBox.Show("Ready to paste!");
		}
    }
}